/** @type {import('tailwindcss').Config} */
const plugin = require('tailwindcss/plugin')

module.exports = {
  content: [
    './template-parts/**/*.php'
  ],
  theme: {
    extend: {
      screens: {
        '3xl': '1920px',
      },
      backgroundImage: {
        "gradient-black": "linear-gradient(180deg, rgba(0, 0, 0, 0.2) 0%, rgba(0, 0, 0, 0) 100%)"
      },
      container: {
        center: true,
        padding: {
          DEFAULT: '1rem',
          sm: '2rem',
          lg: '2.5rem',
          xl: '3rem',
          // '2xl': '5rem',
          // '3xl': "8.4rem"
        }
      },
      fontFamily: {
        // alexa: ['Alexandria', 'sans-serif']
      },
      colors: {
        "black-medium": "#2F2412",
      },
    },
  },
  plugins: [
    plugin(function ({ addBase, theme }) {
      addBase({
        'h1, .h1': {
          fontWeight: 400,
          fontSize: "calc(38px + (52 - 38) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
        'h2, .h2': {
          fontWeight: 500,
          fontSize: "calc(24px + (26 - 24) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
        'h3, .h3': {
          fontWeight: 400,
          fontSize: "calc(16px + (18 - 16) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
        'h4, h5, .h4': {
          fontWeight: 300,
          fontSize: "calc(12px + (14 - 12) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
        'p, .p, .parrafo': {
          fontWeight: 400,
          fontSize: "calc(12px + (14 - 12) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
        '.size-btn': {
          fontWeight: 300,
          fontSize: "calc(12px + (14 - 12) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
        '.size-btn-medium': {
          fontWeight: 600,
          fontSize: "calc(10px + (12 - 10) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
        '.size-small': {
          fontWeight: 300,
          fontSize: "calc(12px + (12 - 12) * ((100vw - 300px) / (2300 - 300)))",
          lineHeight: 1.2
        },
      })
    }),
  ],
}

